//  Created by Allen Ingling on Fri Jun 18 2004.
//  Copyright (c) 2004 New York University. All rights reserved.

	
#import			"KeyRecorderWindow.h"
#include		"PrecisionTime.h"

@implementation KeyRecorderWindow

- (void)clearQueue
{
	[queue removeAllObjects];
}

- (void)stopQueue
{
	enableFlag=FALSE;
}

- (NSMutableArray*)getQueue
{
	NSMutableArray		*returnQueue;

	returnQueue= [queue copy];
	[returnQueue autorelease];
	return(returnQueue);

}

- (void)startQueue
{
	//record the start time reference here
	timeReferenceMark=GetPrecisionTimeSinceStartupInSecsAsDouble();
	enableFlag=TRUE;

}

- (void)setEventTimeReference
{
	timeReferenceMark=GetPrecisionTimeSinceStartupInSecsAsDouble();
}

- (void)useAbsoluteEventTime
{
	timeReferenceMark=0;
}




//override methods

- (void)awakeFromNib
{
	queue=[[NSMutableArray alloc] initWithCapacity:(unsigned)0];
	enableFlag=FALSE;
}

- (void)dealloc
{
	[queue release];
	[super dealloc];
}

- (void)keyDown:(NSEvent *)theEvent
{
	CharTime		*charTime;
	unsigned		queueLength;
	NSMutableArray *fooBar, *localCopy;
	
	localCopy=queue;
	fooBar=[[NSMutableArray alloc] init];
	
	//add something here to subtract the start time recorded in startQueue from the time stamp
	if(enableFlag){
		charTime=[[CharTime alloc] init];
		[charTime setKeyString:[theEvent characters] timeStamp:[theEvent timestamp]-timeReferenceMark];
		queueLength=[queue count];
		[queue addObject:charTime];
		queueLength=[queue count];
		
		[fooBar addObject:(id)charTime];
		queueLength=[fooBar count];
		
		[charTime release];
	}
}

@end
